%% Plot_figures_2_3

%% Construct degree distribution vectors for log-log plot (Figure 2)
x_in = [];
y_in = [];
x_out = [];
y_out = [];
for t=1:size(banks_status_mtx,1)
    x_in = [x_in; log(FDegDistin(FDegDistin(:,t)>0,t))];
    y_in = [y_in; logprobDatain(FDegDistin(:,t)>0,t)];
    x_out = [x_out; log(FDegDistout(FDegDistout(:,t)>0,t))];
    y_out = [y_out; logprobDataout(FDegDistout(:,t)>0,t)];
end

%% Construct ER curve for Figure 2
% Construct x axis
x_th = log(1:1:max(max(FDeg)))';

% Average density of networks
tmp2 = zeros(size(banks_status_mtx,1),1);
for t = 1:size(banks_status_mtx,1)
    tmp = adj_ALL{1,t};
    tmp2(t,1) = sum(sum(tmp(banks_status_mtx(t,:)'==1,banks_status_mtx(t,:)==1),2),1)/...
        (sum(banks_status_mtx(t,:)==1)*(sum(banks_status_mtx(t,:)==1)-1));
end
avg_dens = mean(tmp2);
clear tmp tmp2 t

% Average number of active nodes
normfac = round(mean(sum(banks_status_mtx==1,2)));

% Construct ER P(X>=k) (see paper for explanation)
ER_cdf = ones(length(x_th),1);
ER_cdf(1,1) = nchoosek(normfac-1,0)*(avg_dens^0)*((1-avg_dens)^(normfac-1-0));
for i = 2:1:min((normfac-1),length(x_th))
    ER_cdf(i,1) = ER_cdf(i-1,1) + (nchoosek(normfac-1,i-1)*(avg_dens^(i-1))*((1-avg_dens)^(normfac-1-(i-1))));
end
ER_cdf = round(ones(length(x_th),1)-ER_cdf,12);

% Construct log(P(X>=k))
ln_ER_cdf = log(ER_cdf);

%% Construct BA curves for Figures 2 and 3
% Construct BA pdf (see paper for explanation)
BA_pdf = (1:1:max(max(FDeg)))'.^(-3);
tmp = sum(BA_pdf);
BA_pdf = BA_pdf./tmp;

% Construct BA P(X>=k)
BA_cdf = ones(length(x_th),1);
for i = 2:1:length(x_th)
    BA_cdf(i,1) = BA_cdf(i-1,1)-BA_pdf(i-1,1);
end

% Construct log(P(X>=k))
ln_BA_cdf = log(BA_cdf);
clear tmp i

%% Plot Figure 2
figure('Color',[1 1 1])
hold all
scatter(x_in,y_in,'b')
scatter(x_out,y_out,'r')
plot(x_th,ln_ER_cdf,'c')
plot(x_th,ln_BA_cdf,'g')
title('Degree Distributions')
legend('In-degree','Out-degree','Erdos-Renyi','Barabasi-Albert','Location','best');
grid on
ylim([floor(min([y_in; y_out])) 0])
yticks(floor(min([y_in; y_out])):1:0)
xlim([0 ceil(max([x_in; y_in]))])
xticks(0:1:ceil(max([x_in; y_in])))
hold off

%% Construct ER pdf for Figure 3
ER_pdf = zeros(length(x_th),1);
for i = 1:1:min((normfac-1),length(x_th))
    ER_pdf(i,1) = nchoosek(normfac-1,i-1)*(avg_dens^(i-1))*((1-avg_dens)^(normfac-1-(i-1)));
end
clear i

%% Construct data pdfs
in_pdf = zeros(length(x_th),1);
out_pdf = zeros(length(x_th),1);

for i = 1:length(x_th)
    in_pdf(i,1) = sum(round(FDegDistin(:))==i);
    out_pdf(i,1) = sum(round(FDegDistout(:))==i);
end

in_pdf = in_pdf./sum(in_pdf);
out_pdf = out_pdf./sum(out_pdf);

%% Plot Figure 3
figure('Color',[1 1 1])
hold all
plot(exp(x_th),in_pdf,'b')
plot(exp(x_th),out_pdf,'r')
plot(exp(x_th),ER_pdf,'c')
plot(exp(x_th),BA_pdf,'g')
title('Probability Mass Functions')
legend('In-degree','Out-degree','Erdos-Renyi','Barabasi-Albert','Location','best');
grid on
if Flag==1
    ylim([0 0.2])
    yticks([0 0.05 0.1 0.15 0.2])
end
xlim([1 normfac])
hold off

clear normfac x_th x_in x_out y_in y_out BA_cdf BA_pdf ER_cdf ER_pdf ln_BA_cdf ln_ER_cdf i
