%% Plot_figure_8

if Flag == 1
    time = datetime(unique(loans_aggreg(:,1)),'ConvertFrom','datenum','Format','MMM-yy');
else
    time = (1:1:size(coreSize_min,1))';
end

figure('Color',[1 1 1])
hold all
pm = plot(time,coreSize_min(:,1),'-m','Linewidth',1.3);
plot(time,coreSize_max(:,1),'-m','Linewidth',1.3);
py = plot(time,coreSize_min(:,2),'-y','Linewidth',1.3);
plot(time,coreSize_max(:,2),'-y','Linewidth',1.3);
pr = plot(time,coreSize_min(:,3),'-r','Linewidth',1.3);
plot(time,coreSize_max(:,3),'-r','Linewidth',1.3);
pb = plot(time,coreSize_min(:,4),'-b','Linewidth',1.3);
plot(time,coreSize_max(:,4),'-b','Linewidth',1.3);
title('Core size')
legend([pm py pr pb],'Correlation','Maximum likelihood','Density-based',...
    'Craig & von Peter','Location','best','Orientation','horizontal')
grid on
if Flag == 1
    ylim([0 20])
    ax = gca;
    ax.YTick=[0 2 4 6 8 10 12 14 16 18 20];
    xlim(datetime([2005 2016],[1 12],[1 31]))
    xtickformat('MMM-yy')
    clear ax
end
hold off

clear time pm py pr pb