%% Plot_figure_11

if Flag == 1
    time = datetime(unique(loans_aggreg(:,1)),'ConvertFrom','datenum','Format','MMM-yy');
else
    time = (1:1:size(Vol,1))';
end

figure('Color',[1 1 1])
hold all
plot(time,Vol(:,1),'-b','Linewidth',1.3)
plot(time,Vol(:,2),'-r','Linewidth',1.3)
title('Lending Volumes')
legend(['Majors to non-majors'; 'Non-majors to majors']);
grid on
if Flag == 1
    ylim([0 210])
    ax = gca;
    ax.YTick=[0 30 60 90 120 150 180 210];
    xlim(datetime([2005 2016],[1 12],[1 31]))
    xtickformat('MMM-yy')
    clear ax
end
hold off

clear time