%% plot_figure_1

if Flag == 1
    time = datetime(unique(loans_aggreg(:,1)),'ConvertFrom','datenum','Format','MMM-yy');
else
    time = (1:1:size(SummaryStatsData,1))';
end

figure('Color',[1 1 1])
subplot(2,2,1)
plot(time,SummaryStatsData(:,2),'-b','Linewidth',1.3)
title('Active banks (nodes)')

if Flag == 1
    ylim([30 50])
    ax = gca;
    ax.YTick=[30 35 40 45 50];
end

subplot(2,2,2)
plot(time,SummaryStatsData(:,4),'-k','Linewidth',1.3)
title('Loan relationships (links)')

if Flag == 1
    ylim([250 650])
    ax = gca;
    ax.YTick=[250 350 450 550 650];
end

subplot(2,2,3)
plot(time,SummaryStatsData(:,3),'-r','Linewidth',1.3)
title('Lending volumes')


subplot(2,2,4)
plot(time,SummaryStatsData(:,5),'-m','Linewidth',1.3)
title('Network density')

if Flag == 1
    ylim([0.1 0.4])
    ax = gca;
    ax.YTick=[0.1 0.2 0.3 0.4];
end
