%% getVols
%
% This function constructs an NxNxT array of total loan values along each
% directional edge (from node i to node j) in network t
%
% =========================================================
% AUTHOR AND INSTITUTION INFO:
% Written by Anthony Brassil and Gabriela Nodari 
% Reserve Bank of Australia
% This version: January 2018
% ==========================================================

function [Vol_array]=getVols(loans_aggreg,banks_status_mtx)

% Create loan volume array
Vol_array = zeros(size(banks_status_mtx,2),size(banks_status_mtx,2),size(banks_status_mtx,1));

% Create vector of network IDs
time = unique(loans_aggreg(:,1));

for t_idx=1:size(banks_status_mtx,1)
    % Pick relevant network
    network = time(t_idx);
    
    % Value of loans along each edge for given network
    for ij = find(loans_aggreg(:,1)==network,1,'first'):find(loans_aggreg(:,1)==network,1,'last') 
        Vol_array(loans_aggreg(ij,2),loans_aggreg(ij,3),t_idx) = loans_aggreg(ij,5);
    end
end

end