%% getNetwork
%
% This function constructs an Adjacency matrix for each sample period
%
% =========================================================
% AUTHOR AND INSTITUTION INFO:
% Written by Anthony Brassil and Gabriela Nodari 
% Reserve Bank of Australia
% This version: January 2018
% ==========================================================

function [adj_ALL]=getNetwork(loans_aggreg,banks_status_mtx)

% Create cell array to store adjacency matrix for each period
adj_ALL = cell(1,size(banks_status_mtx,1)); 

% Create vector of network IDs
time = unique(loans_aggreg(:,1));

for t_idx=1:size(banks_status_mtx,1)
    
    network = time(t_idx);
    
    % Create adjacency matrix
    adj_mtx = zeros(size(banks_status_mtx,2),size(banks_status_mtx,2));
    
    % Identify transactions of a given period
    for ij = find(loans_aggreg(:,1)==network,1,'first'):find(loans_aggreg(:,1)==network,1,'last') 
        adj_mtx(loans_aggreg(ij,2),loans_aggreg(ij,3))=1;
    end

    % Store the adjacency matrix
    adj_ALL{1,t_idx}= adj_mtx;
    
end

end