%% getDegs
%
% This function computes the degrees, normalised degrees, and log
% probabilities (for use in constructing degree distributions).
%
% =========================================================
% AUTHOR AND INSTITUTION INFO:
% Written by Anthony Brassil and Gabriela Nodari
% Reserve Bank of Australia
% This version: January 2018
% ==========================================================

function [FDeg,FDegin,FDegout,FDegDistin,FDegDistout,logprobDatain,logprobDataout] = getDegs(adj_ALL,banks_status_mtx)

% Initialise degree matices
FDeg = zeros(size(banks_status_mtx,2),size(banks_status_mtx,1));
FDegin = zeros(size(banks_status_mtx,2),size(banks_status_mtx,1));
FDegout = zeros(size(banks_status_mtx,2),size(banks_status_mtx,1));
FDegDistin = zeros(size(banks_status_mtx,2),size(banks_status_mtx,1));
FDegDistout = zeros(size(banks_status_mtx,2),size(banks_status_mtx,1));

% Compute degree distributions
for t=1:size(banks_status_mtx,1)
    % Network t adjaceny matrix
    adj = adj_ALL{1,t};
    
    % Degrees of each node
    FDegin(:,t) = sum(adj,1)';
    FDegout(:,t) = sum(adj,2);
    FDeg(:,t) = FDegin(:,t) + FDegout(:,t);
    
    % Average number of active nodes
    normfac = round(mean(sum(banks_status_mtx==1,2)));
    
    % Normalised degrees (sorted)
    FDegDistin(:,t) = sort((FDegin(:,t)./sum(FDeg(:,t)>0)).*normfac,'descend');
    FDegDistout(:,t) = sort((FDegout(:,t)./sum(FDeg(:,t)>0)).*normfac,'descend');
end

% Initialise log probability matrices
logprobDatain = zeros(size(banks_status_mtx,2),size(banks_status_mtx,1));
logprobDataout = zeros(size(banks_status_mtx,2),size(banks_status_mtx,1));

% Construct log probabilities
for t = 1:size(banks_status_mtx,1)
    for i = 1:size(banks_status_mtx,2)
        logprobDatain(i,t) = log(sum(FDegDistin(:,t)>=FDegDistin(i,t))/sum(FDegDistin(:,t)>0));
        logprobDataout(i,t) = log(sum(FDegDistout(:,t)>=FDegDistout(i,t))/sum(FDegDistout(:,t)>0));
    end
end

end

