%% aggregateLoans
%
% This function aggregates gross transactions into
% quarterly/monthly/weekly/daily frequencies
%
% =========================================================
% AUTHOR AND INSTITUTION INFO:
% Written by Anthony Brassil and Gabriela Nodari 
% Reserve Bank of Australia
% This version: January 2018
% ==========================================================

function [loans_aggreg]=aggregateLoans(tradingdays,loans_all,frequency)

yearstart = year(tradingdays(1));
yearend = year(tradingdays(end));
loans_aggreg =[];  
myrows = @(x) size(x,1);
%***************************************************************************

if frequency == 1 % (Quarterly)
    
    while yearstart <= yearend
        
        dd1=datenum(yearstart,1,1);
        dd2=datenum(yearstart,3,31);
        tlower = find(loans_all(:,1)>=dd1,1,'first'); % Find all transactions within the quarter
        tupper = find(loans_all(:,1)<=dd2,1,'last');
        
        % Aggregate gross loans between same counterparties
        [bankpair,counts,loan]= grpstats(loans_all(tlower:tupper,4),loans_all(tlower:tupper,2:3),{'gname','numel',@sum});
        
        if not(isempty(loans_all(tlower:tupper,4)))
            loans_aggreg = [loans_aggreg; repmat(dd1,size(loan,1),1) str2double(bankpair) counts loan];
        end
        
        dd1=datenum(yearstart,4,1);
        dd2=datenum(yearstart,6,30);
        tlower = find(loans_all(:,1)>=dd1,1,'first');
        tupper = find(loans_all(:,1)<=dd2,1,'last');
        
        [bankpair,counts,loan]= grpstats(loans_all(tlower:tupper,4),loans_all(tlower:tupper,2:3),{'gname','numel',@sum});
        
        if not(isempty(loans_all(tlower:tupper,4)))
            loans_aggreg = [loans_aggreg; repmat(dd1,size(loan,1),1) str2double(bankpair) counts loan];
        end
        
        dd1=datenum(yearstart,7,1);
        dd2=datenum(yearstart,9,30);
        tlower = find(loans_all(:,1)>=dd1,1,'first');
        tupper = find(loans_all(:,1)<=dd2,1,'last');
        
        [bankpair,counts,loan]= grpstats(loans_all(tlower:tupper,4),loans_all(tlower:tupper,2:3),{'gname','numel',@sum});
        
        if not(isempty(loans_all(tlower:tupper,4)))
            loans_aggreg = [loans_aggreg; repmat(dd1,size(loan,1),1) str2double(bankpair) counts loan];
        end
        
        dd1=datenum(yearstart,10,1);
        dd2=datenum(yearstart,12,31);
        tlower = find(loans_all(:,1)>=dd1,1,'first');
        tupper = find(loans_all(:,1)<=dd2,1,'last');
        
        [bankpair,counts,loan]= grpstats(loans_all(tlower:tupper,4),loans_all(tlower:tupper,2:3),{'gname','numel',@sum});
        
        if not(isempty(loans_all(tlower:tupper,4)))
            loans_aggreg = [loans_aggreg; repmat(dd1,size(loan,1),1) str2double(bankpair) counts loan];
        end
        
        yearstart = yearstart+1;
    end
    
end

%***************************************************************************
if frequency == 2 % (Monthly)

    % Construct matrix of start and end dates of each month in the sample
    datebeg = datenum(year(tradingdays(1)),month(tradingdays(1)),1);
    dateend = datenum(year(tradingdays(end)),month(tradingdays(end))+1,1)-1;
    mymonths = [];
    datenow = datebeg;
    while datenow < dateend
        mymonths = [mymonths; datenow, datenum(year(datenow),month(datenow)+1,1)-1];
        datenow = datenum(year(datenow),month(datenow)+1,1);
    end    
    
    for i=1:myrows(mymonths)
        tlower = find(loans_all(:,1)>=mymonths(i,1),1,'first'); 
        tupper = find(loans_all(:,1)<=mymonths(i,2),1,'last');
        
        [bankpair,counts,loan]= grpstats(loans_all(tlower:tupper,4),loans_all(tlower:tupper,2:3),{'gname','numel',@sum});
        
        if not(isempty(loans_all(tlower:tupper,4)))
            loans_aggreg = [loans_aggreg; repmat(mymonths(i,1),size(loan,1),1) str2double(bankpair) counts loan];
        end
    end    
    
end 

%***************************************************************************
if frequency == 3 % (Weekly)

    % Construct matrix of start and end dates of each week in the sample
    datebeg = datenum(year(tradingdays(1)),month(tradingdays(1)),day(tradingdays(1)))-weekday(tradingdays(1))+1;
    dateend = datenum(year(tradingdays(end)),month(tradingdays(end)),day(tradingdays(end)))-weekday(tradingdays(end))+7;
    myweeks = [];
    datenow = datebeg;
    while datenow < dateend
        myweeks = [myweeks; datenow, datenow+6];
        datenow = datenow + 7;
    end    
    
    for i=1:myrows(myweeks)
        tlower = find(loans_all(:,1)>=myweeks(i,1),1,'first'); 
        tupper = find(loans_all(:,1)<=myweeks(i,2),1,'last');
        
        [bankpair,counts,loan]= grpstats(loans_all(tlower:tupper,4),loans_all(tlower:tupper,2:3),{'gname','numel',@sum});
        
        if not(isempty(loans_all(tlower:tupper,4)))
            loans_aggreg = [loans_aggreg; repmat(myweeks(i,1),size(loan,1),1) str2double(bankpair) counts loan];
        end
    end 
end

%***************************************************************************
if frequency == 4 % (Daily)
    
     for i=1:myrows(tradingdays)
         tlower = find(loans_all(:,1)==tradingdays(i,1),1,'first'); 
         tupper = find(loans_all(:,1)==tradingdays(i,1),1,'last');
        
        [bankpair,counts,loan]= grpstats(loans_all(tlower:tupper,4),loans_all(tlower:tupper,2:3),{'gname','numel',@sum});
        
        if not(isempty(loans_all(tlower:tupper,4)))
            loans_aggreg = [loans_aggreg; repmat(tradingdays(i,1),size(loan,1),1) str2double(bankpair) counts loan];
        end
     end 
        
end 

end
