%% RUN_stats
%
% DESCRIPTION
%
% This script calculates the summary statistics reported in Figure 1 of 
% Brassil and Nodari (2018). It also plots Figure 1.
%
% =====================================================================
% IMPORTANT INFORMATION
%
% This script requires the Statistics and Machine Learning Toolbox.
%
% =========================================================
% AUTHORS AND INSTITUTION INFO:
% Codes written by Anthony Brassil and Gabriela Nodari 
% Reserve Bank of Australia
% This version: January 2018
% ==========================================================

clear all
clc
close all

%% Parameters

% When Flag=1 and data.mat contains the data used in Brassil and Nodari (2018)
% this script will replicate Figure 1 in our paper.
%
% If running the script with a different dataset or with a frequency 
% other than quarterly, set Flag=0
Flag = 0;

%% Summary Statistics 
load 'data.mat'

% Compute summary statiscs by date
[dates,edges,loanstot] = grpstats(loans_aggreg(:,5),loans_aggreg(:,1),{'gname','numel',@sum});

% Network size (# of nodes)
activebanks = sum(banks_status_mtx,2,'omitnan'); 

% Network Density 
density = edges./(activebanks.^2 - activebanks);

% Store the results
SummaryStatsData = [str2double(dates) activebanks loanstot edges density];

% Plot Figure 1
plot_figure_1




















