%% RUN_set_up_data
%
% DESCRIPTION
%
% This script aggregates a loan-level dataset into a chosen frequency
% between quarterly, monthly, weekly or daily. The aggregate loans are 
% saved in a matrix called 'loans_aggreg'. It also constructs a matrix
% called 'banks_status_mtx'. The banks_status_mtx is a TxN matrix. Cell 
% (t,i) contains the status of node i in network t. If there are any
% edges connected to node i in network t, the bank is active and has a 
% value of one. If never any edges, the node is never active and has a 
% value of NaN. If no edges in network t but edges in some network s~=t, 
% then (t,i) has a value of zero.
%
% =====================================================================
% IMPORTANT INFORMATION
%
% This script requires the 'Finance' and 'Statistics and Machine Learning' 
% toolboxes.
%
% This script will remove any periods with empty networks. For example, if
% your data contains networks for January and March, but not February, this
% script will remove February from from banks_status_mtx. Since the
% RUN_data.m script is more general (i.e. it does not require dated
% networks), it does not know that February has been removed, and will
% treat the January and March networks as consecutive periods (e.g. in the
% construction of the density index). So caution is advised.
%
% ===================================================================
% AUTHOR AND INSTITUTION INFO:
% Written by Anthony Brassil and Gabriela Nodari
% Reserve Bank of Australia
% This version: January 2018
% ==================================================================

clear all
clc
close all

%% Parameters
frequency = 1;  % Choose the aggregation frequency:
                % 1=quarterly 2=monthly 3=weekly 4=daily

%% Load raw data
% The dataset should be stored in a matrix with the following
% four columns:
%
%            1 date   --> expressed in Matlab format
%            2 lender ID
%            3 borrower ID
%            4 loan size
% 
% This matrix should be called loans_all and either be housed in a data
% file called loans_all.mat or, if the data is in a non-Matlab format, be 
% constructed from a user-written script called data_load.m

if exist('loans_all.mat','file')==2
    load('loans_all.mat','loans_all')
else
    [loans_all]= data_load;
end

%% Aggregate data

% Classify banks as active/inactive for each sample period
    [banks_status_mtx,tradingdays]=getNodes(loans_all,frequency);

% Aggregate (gross) transactions
    [loans_aggreg]=aggregateLoans(tradingdays,loans_all,frequency);
    
save('data.mat','loans_aggreg','banks_status_mtx','loans_all') 









