%% RUN_check_intermediation
%
% ==================================================================
% AUTHOR AND INSTITUTION INFO:
% Written by Anthony Brassil and Gabriela Nodari
% Reserve Bank of Australia
% This version: January 2018
% ==================================================================
%
% DESCRIPTION:
% This script calculates the share of days in which each bank both lends 
% and borrows in the IBOC market. It replicates Figure F1.
% This script is designed to be run on loan-level data.
%
% ==================================================================
%
% PREREQUISITES:
% RUN_set_up_data.m and RUN_data.m must be run before running this script.
%
% ==================================================================
clear all
clc
close all

%% Load required inputs
load 'data.mat'
filename = ['Core_',num2str(size(banks_status_mtx,1)),'.mat'];
load(filename,'CPvecGlob','Flag','banks_status_mtx')

%% Determine days in which each bank either lends or borrows
tradingdays = unique(loans_all(:,1));
daily_loan = zeros(size(tradingdays,1),size(banks_status_mtx,2),2);
for i = 1:size(banks_status_mtx,2)
    daily_loan(:,i,1)=ismember(tradingdays,unique(loans_all(loans_all(:,2)==i,1)));
    daily_loan(:,i,2)=ismember(tradingdays,unique(loans_all(loans_all(:,3)==i,1)));    
end

%% Determine share of days in which each bank both borrows and lends
% As a share of days with some borrowing/lending

% Determine first and last day of each period
periods = unique(loans_aggreg(:,1));
periods(1:size(periods,1)-1,2) = periods(2:size(periods,1),1)-1;
periods(size(periods,1),2) = tradingdays(end);

% Determine share of days where borrowing and lending for each bank
both_share = zeros(size(banks_status_mtx,1),size(banks_status_mtx,2));
for t = 1:size(banks_status_mtx,1)
    for i = 1:size(banks_status_mtx,2)
        daysvec = tradingdays>=periods(t,1) & tradingdays<=periods(t,2);
        both_share(t,i) = sum(daily_loan(daysvec,i,1)==1&daily_loan(daysvec,i,2)==1)/sum(daily_loan(daysvec,i,1)==1|daily_loan(daysvec,i,2)==1);
    end
end

%% Construct simple averages for core and periphery for each period
data_check_intermediation = zeros(size(banks_status_mtx,1),2);
for i = 1:size(banks_status_mtx,1)
    data_check_intermediation(i,1) = mean(both_share(i,CPvecGlob{3,i}==1),'omitnan');
    data_check_intermediation(i,2) = mean(both_share(i,CPvecGlob{3,i}==0),'omitnan');
end

%% Plot Figure F1
plot_figure_F1


